######################################################################
#                                                                    #
#          SCRIPT : RETROPOLATION OF EUROPEAN URBAN AREAS            #
#                     By Antonin Pavard - 2015                       #
#                                                                    #
######################################################################


###################### Upload of data ##########################

# Defining location of the archive file
pathToShp <- "set up path to archive file"
# Importing shape
lau2_geom <- readOGR(dsn=pathToShp, layer="LAU2_Cont_EnvRest_St_Fin_Corr", stringsAsFactors=FALSE)
# Switch attributes names to lower-case input
names(lau2_geom) <- tolower(names(lau2_geom))

############### Selection of dates and population threshold applied to LAU2 ##################

# Set up population threshold for the LAU2 selection
seuilselect <- 2000

# Set up population attributes for LAU2 selection
select_lau2_01 <- "x2001pop"
select_lau2_91 <- "x1991pop"
select_lau2_81 <- "x1981pop"
select_lau2_71 <- "x1971pop"
select_lau2_61 <- "x1961pop"

#### Module pour l'anne 2001
# Enregistrer les LAU2 respectant le seuil dans un nouveau shape
lau2_geom_date <- lau2_geom[lau2_geom$x2001pop>=seuilselect | lau2_geom$x1991pop>=seuilselect | lau2_geom$x1981pop>=seuilselect | lau2_geom$x1971pop>=seuilselect | lau2_geom$x1961pop>=seuilselect,]
# Trier les donnes de lau2_geom_date en fonction de l'identifiant umz
lau2_geom_date <- lau2_geom_date[order(lau2_geom_date$unit_code,decreasing=FALSE),]

# Reprsenter les contours des lau2 slectionnes
plot(lau2_geom_date, lwd = 1)


############### Selection of dates and density thresholds applied to LAU2 ##################

# parametrer le seuil de slection des LAU2
seuilselect <- 150

# Variable densit pour slection ds LAU2
select_lau2_01 <- "x2001dens"
select_lau2_91 <- "x1991dens"
select_lau2_81 <- "x1981dens"
select_lau2_71 <- "x1971dens"
select_lau2_61 <- "x1961dens"

#### Module pour l'anne 2001
# Enregistrer les LAU2 respectant le seuil dans un nouveau shape
lau2_geom_date <- lau2_geom[lau2_geom$x2001dens>=seuilselect | lau2_geom$x1991dens>=seuilselect | lau2_geom$x1981dens>=seuilselect | lau2_geom$x1971dens>=seuilselect | lau2_geom$x1961dens>=seuilselect,]
# Trier les donnes de lau2_geom_date en fonction de l'identifiant umz
lau2_geom_date <- lau2_geom_date[order(lau2_geom_date$unit_code,decreasing=FALSE),]



####################Partie spatiale sous PostGis######################

# 0. Dclarer les variables gnrales
# Couche des LAU2 slectionnes
lau2_date <- "lau2_geom_date"
# Couche des LAU2 origines
lau2_ori <- "lau2_geom"
# Identifiant UMZ
id_umz <- "unit_code"
# Identifiant LAU2
id_lau2 <- "comm_id11"
# Variable population
pop_lau2_01 <- "x2001pop"
pop_lau2_91 <- "x1991pop"
pop_lau2_81 <- "x1981pop"
pop_lau2_71 <- "x1971pop"
pop_lau2_61 <- "x1961pop"
# Identifiant UMZ cr  la fin
umz_date_01 <- "umz2001"
umz_date_91 <- "umz1991"
umz_date_81 <- "umz1981"
umz_date_71 <- "umz1971"
umz_date_61 <- "umz1961"



# 1. Etablir la connexion   PoststgreSQL
drv <- dbDriver("PostgreSQL")
con <- dbConnect(drv, dbname="postgis_db",host="localhost",port=5432,user="postgres",password="2574be")

# 2. Transferer des couches dans la BD PostGis
# On met les noms des champs en minuscule et on copie les deux tables dans la BD Postgis
dbWriteSpatial(con, lau2_geom_date, schemaname="public", tablename="lau2_geom_date", replace=T, srid=3035)
dbWriteSpatial(con, lau2_geom, schemaname="public", tablename="lau2_geom", replace=T, srid=3035)
q<-paste("create index ",lau2_date,"_geom_gist on ",lau2_date," using gist(geom);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index ",lau2_ori,"_geom_gist on ",lau2_ori," using gist(geom);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)


# 3. Crer les enveloppes umz  partir de l'identifiant des UMZ
# Eriture de la requte PostGIS
q<-paste("create table env_umz as (select ",id_umz,", ST_Union(geom) as geom from ",lau2_date," GROUP BY
",id_umz,");",sep="")
# Execution de la requete
res<-dbSendQuery(con,q)
# Libration des ressources
dbClearResult(res)
q<-paste("create index env_umz_geom_gist on env_umz using gist(geom);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 4. Extraire les contours exterieurs des polygones pour liminer les trous
q<-paste("create table env_umz_comp as (select ",id_umz,", st_exteriorRing((st_dump(geom)).geom) as g from env_umz);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index env_umz_comp_g_gist on env_umz_comp using gist(g);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 5. Reconstruire les enveloppes umz en polygones
q<-paste("create table simplerings as (select st_linemerge(st_union(g)) as g from env_umz_comp);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table simplelines as (select (st_dump(g)).geom as g from simplerings);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table poly_env as (select (st_dump (st_polygonize(distinct g))).geom as g from simplelines);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index poly_env_g_gist on poly_env using gist(g);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz_pt as (select ",id_umz,", st_pointOnSurface((st_dump(geom)).geom) as geom from env_umz);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 6. Rcuprer les IDs des enveloppes
# Ajout de l'id
q<- paste("alter table poly_env add column gid serial primary key;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
# Recuperation des id par jointure spatiale
q<-paste("create table poly_env_id as (select ",id_umz,", g from env_umz_pt d, poly_env s where st_contains(s.g, d.geom));",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 7. METHODE ROOT - Identifier les enveloppes contigues (contiguit root) qui ont le mme ID
q<- paste("ALTER TABLE poly_env_id ADD COLUMN gid_a serial primary key;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE poly_env_id ADD COLUMN umz_contig text;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE poly_env_id SET umz_contig = concat(",id_umz,",'_', gid_a);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 8. METHODE ROOT - Slection des LAU2 qui composent des UMZ de 10 000 habitants et plus
q<- paste("CREATE TABLE lau2_env_root AS SELECT DISTINCT ON (",lau2_ori,".",id_lau2,") ",lau2_ori,".*, poly_env_id.umz_contig from ",lau2_ori,", poly_env_id WHERE poly_env_id.g && ",lau2_ori,".geom AND ST_Contains(poly_env_id.g, ST_PointOnSurface(",lau2_ori,".geom));",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz AS SELECT umz_contig, SUM(",pop_lau2_01,") AS pop_tot_01, SUM(",pop_lau2_91,") AS pop_tot_91, SUM(",pop_lau2_81,") AS pop_tot_81, SUM(",pop_lau2_71,") AS pop_tot_71, SUM(",pop_lau2_61,") AS pop_tot_61, MIN(",id_umz,") AS ",id_umz," FROM lau2_env_root GROUP BY umz_contig ORDER BY MIN(",id_umz,") ASC, pop_tot_01 DESC;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("DELETE FROM select_umz WHERE pop_tot_01<10000 AND pop_tot_91<10000 AND pop_tot_81<10000 AND pop_tot_71<10000 AND pop_tot_61<10000;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz_rank AS SELECT *, rank() OVER (PARTITION BY ",id_umz," ORDER BY pop_tot_01 DESC) FROM select_umz;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz_count AS SELECT ",id_umz,", COUNT(",id_umz,") FROM select_umz GROUP BY ",id_umz,";",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umzfin AS SELECT select_umz_rank.*, select_umz_count.count  FROM select_umz_count  INNER JOIN select_umz_rank ON select_umz_count.",id_umz," = select_umz_rank.",id_umz,";",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE select_umzfin ADD COLUMN ",umz_date_01," text;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE select_umzfin SET ",umz_date_01," = concat(",id_umz,",'_', rank) WHERE count > 1;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE select_umzfin SET ",umz_date_01," = concat(",id_umz,") WHERE count = 1;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE lau2_rootfinal AS SELECT lau2_env_root.*, select_umzfin.pop_tot_01, select_umzfin.",umz_date_01,"  FROM select_umzfin  INNER JOIN lau2_env_root ON select_umzfin.umz_contig = lau2_env_root.umz_contig;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("alter table lau2_rootfinal drop umz_contig;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
# Crer le nouveau fichier de rfrence
q<-paste("CREATE TABLE LAU2_new_ref AS SELECT (",lau2_ori,".*), lau2_rootfinal.",umz_date_01," FROM ",lau2_ori," LEFT OUTER JOIN lau2_rootfinal ON (",lau2_ori,".",id_lau2," = lau2_rootfinal.",id_lau2,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 9.PostGIS database clean-up
res1<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz')")
dbClearResult(res1)
res2<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz_comp')")
dbClearResult(res2)
res3<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_env_root')")
dbClearResult(res3)
res4<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_geom')")
dbClearResult(res4)
res5<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_geom_date')")
dbClearResult(res5)
res6<-dbSendQuery(con,"SELECT DropGeometryTable('poly_env')")
dbClearResult(res6)
res7<-dbSendQuery(con,"SELECT DropGeometryTable('poly_env_id')")
dbClearResult(res7)
res8<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz')")
dbClearResult(res8)
res9<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz_rank')")
dbClearResult(res9)
res10<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz_count')")
dbClearResult(res10)
res11<-dbSendQuery(con,"SELECT DropGeometryTable('select_umzfin')")
dbClearResult(res11)
res12<-dbSendQuery(con,"SELECT DropGeometryTable('simplerings')")
dbClearResult(res12)
res13<-dbSendQuery(con,"SELECT DropGeometryTable('simplelines')")
dbClearResult(res13)
res14<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz_pt')")
dbClearResult(res14)
res15<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_rootfinal')")
dbClearResult(res15)

################################ 1991 ###################################

# 10. Slection LAU2 pour t-1 et cration des enveloppes + limination des trous
q<-paste("create table ",lau2_date," as (select * from LAU2_new_ref WHERE ",select_lau2_91," >= ",seuilselect," OR ",select_lau2_81," >= ",seuilselect," OR ",select_lau2_71," >= ",seuilselect," OR ",select_lau2_61," >= ",seuilselect,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz as (select ",umz_date_01,", ST_Union(geom) as geom from ",lau2_date," GROUP BY
",umz_date_01,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index env_umz_geom_gist on env_umz using gist(geom);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz_comp as (select ",umz_date_01,", st_exteriorRing((st_dump(geom)).geom) as g from env_umz);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index env_umz_comp_g_gist on env_umz_comp using gist(g);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 11. Reconstruire les enveloppes umz t-1 en polygones
q<-paste("create table simplerings as (select st_linemerge(st_union(g)) as g from env_umz_comp);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table simplelines as (select (st_dump(g)).geom as g from simplerings);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table poly_env as (select (st_dump (st_polygonize(distinct g))).geom as g from simplelines);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index poly_env_g_gist on poly_env using gist(g);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz_pt as (select ",umz_date_01,", st_pointOnSurface((st_dump(geom)).geom) as geom from env_umz);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 12. Rcuprer les IDs des enveloppes et identifier les UMZ t-1 contigues
# Ajout de l'id
q<- paste("alter table poly_env add column gid serial primary key;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
# Recuperation des id par jointure spatiale
q<-paste("create table poly_env_id as (select ",umz_date_01,", g from env_umz_pt d, poly_env s where st_contains(s.g, d.geom));",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE poly_env_id ADD COLUMN gid_a serial primary key;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE poly_env_id ADD COLUMN umz_contig text;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE poly_env_id SET umz_contig = concat(",umz_date_01,",'_', gid_a);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 13. METHODE ROOT - Slection des LAU2 qui composent des UMZ t-1 de 10 000 habitants et plus
q<- paste("CREATE TABLE lau2_env_root AS SELECT DISTINCT ON (LAU2_new_ref.",id_lau2,") LAU2_new_ref.*, poly_env_id.umz_contig from LAU2_new_ref, poly_env_id WHERE poly_env_id.g && LAU2_new_ref.geom AND ST_Contains(poly_env_id.g, ST_PointOnSurface(LAU2_new_ref.geom));",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz AS SELECT umz_contig, SUM(",pop_lau2_91,") AS pop_tot_91, SUM(",pop_lau2_81,") AS pop_tot_81, SUM(",pop_lau2_71,") AS pop_tot_71, SUM(",pop_lau2_61,") AS pop_tot_61, MIN(",umz_date_01,") AS ",umz_date_01," FROM lau2_env_root GROUP BY umz_contig ORDER BY MIN(",umz_date_01,") ASC, pop_tot_91 DESC;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("DELETE FROM select_umz WHERE pop_tot_91<10000 AND pop_tot_81<10000 AND pop_tot_71<10000 AND pop_tot_61<10000;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz_rank AS SELECT *, rank() OVER (PARTITION BY ",umz_date_01," ORDER BY pop_tot_91 DESC) FROM select_umz;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz_count AS SELECT ",umz_date_01,", COUNT(",umz_date_01,") FROM select_umz GROUP BY ",umz_date_01,";",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umzfin AS SELECT select_umz_rank.*, select_umz_count.count  FROM select_umz_count  INNER JOIN select_umz_rank ON select_umz_count.",umz_date_01," = select_umz_rank.",umz_date_01,";",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE select_umzfin ADD COLUMN ",umz_date_91," text;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE select_umzfin SET ",umz_date_91," = concat(",umz_date_01,",'_', rank) WHERE count > 1;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE select_umzfin SET ",umz_date_91," = concat(",umz_date_01,") WHERE count = 1;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE lau2_rootfinal AS SELECT lau2_env_root.*, select_umzfin.pop_tot_91, select_umzfin.",umz_date_91,"  FROM select_umzfin  INNER JOIN lau2_env_root ON select_umzfin.umz_contig = lau2_env_root.umz_contig;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("alter table lau2_rootfinal drop umz_contig;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
# Crer le nouveau fichier de rfrence
q<-paste("CREATE TABLE LAU2_new_ref_91 AS SELECT (LAU2_new_ref.*), lau2_rootfinal.",umz_date_91," FROM LAU2_new_ref LEFT OUTER JOIN lau2_rootfinal ON (LAU2_new_ref.",id_lau2," = lau2_rootfinal.",id_lau2,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 14. PostGIS database clean-up
res1<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz')")
dbClearResult(res1)
res2<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz_comp')")
dbClearResult(res2)
res3<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_env_root')")
dbClearResult(res3)
res5<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_geom_date')")
dbClearResult(res5)
res6<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_rootfinal')")
dbClearResult(res6)
res7<-dbSendQuery(con,"SELECT DropGeometryTable('poly_env')")
dbClearResult(res7)
res8<-dbSendQuery(con,"SELECT DropGeometryTable('poly_env_id')")
dbClearResult(res8)
res9<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz')")
dbClearResult(res9)
res10<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz_rank')")
dbClearResult(res10)
res11<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz_count')")
dbClearResult(res11)
res12<-dbSendQuery(con,"SELECT DropGeometryTable('select_umzfin')")
dbClearResult(res12)
res13<-dbSendQuery(con,"SELECT DropGeometryTable('simplerings')")
dbClearResult(res13)
res14<-dbSendQuery(con,"SELECT DropGeometryTable('simplelines')")
dbClearResult(res14)
res15<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz_pt')")
dbClearResult(res15)
res16<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_new_ref')")
dbClearResult(res16)

################################ 1981 ###################################

# 10. Slection LAU2 pour t-1 et cration des enveloppes + limination des trous
q<-paste("create table ",lau2_date," as (select * from LAU2_new_ref_91 WHERE ",select_lau2_81," >= ",seuilselect," OR ",select_lau2_71," >= ",seuilselect," OR ",select_lau2_61," >= ",seuilselect,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz as (select ",umz_date_91,", ST_Union(geom) as geom from ",lau2_date," GROUP BY
         ",umz_date_91,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index env_umz_geom_gist on env_umz using gist(geom);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz_comp as (select ",umz_date_91,", st_exteriorRing((st_dump(geom)).geom) as g from env_umz);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index env_umz_comp_g_gist on env_umz_comp using gist(g);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 11. Reconstruire les enveloppes umz t-1 en polygones
q<-paste("create table simplerings as (select st_linemerge(st_union(g)) as g from env_umz_comp);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table simplelines as (select (st_dump(g)).geom as g from simplerings);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table poly_env as (select (st_dump (st_polygonize(distinct g))).geom as g from simplelines);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index poly_env_g_gist on poly_env using gist(g);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz_pt as (select ",umz_date_91,", st_pointOnSurface((st_dump(geom)).geom) as geom from env_umz);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 12. Rcuprer les IDs des enveloppes et identifier les UMZ t-1 contigues
# Ajout de l'id
q<- paste("alter table poly_env add column gid serial primary key;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
# Recuperation des id par jointure spatiale
q<-paste("create table poly_env_id as (select ",umz_date_91,", g from env_umz_pt d, poly_env s where st_contains(s.g, d.geom));",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE poly_env_id ADD COLUMN gid_a serial primary key;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE poly_env_id ADD COLUMN umz_contig text;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE poly_env_id SET umz_contig = concat(",umz_date_91,",'_', gid_a);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 13. METHODE ROOT - Slection des LAU2 qui composent des UMZ t-1 de 10 000 habitants et plus
q<- paste("CREATE TABLE lau2_env_root AS SELECT DISTINCT ON (LAU2_new_ref_91.",id_lau2,") LAU2_new_ref_91.*, poly_env_id.umz_contig from LAU2_new_ref_91, poly_env_id WHERE poly_env_id.g && LAU2_new_ref_91.geom AND ST_Contains(poly_env_id.g, ST_PointOnSurface(LAU2_new_ref_91.geom));",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz AS SELECT umz_contig, SUM(",pop_lau2_81,") AS pop_tot_81, SUM(",pop_lau2_71,") AS pop_tot_71, SUM(",pop_lau2_61,") AS pop_tot_61, MIN(",umz_date_91,") AS ",umz_date_91," FROM lau2_env_root GROUP BY umz_contig ORDER BY MIN(",umz_date_91,") ASC, pop_tot_81 DESC;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("DELETE FROM select_umz WHERE pop_tot_81<10000 AND pop_tot_71<10000 AND pop_tot_61<10000;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz_rank AS SELECT *, rank() OVER (PARTITION BY ",umz_date_91," ORDER BY pop_tot_81 DESC) FROM select_umz;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz_count AS SELECT ",umz_date_91,", COUNT(",umz_date_91,") FROM select_umz GROUP BY ",umz_date_91,";",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umzfin AS SELECT select_umz_rank.*, select_umz_count.count  FROM select_umz_count  INNER JOIN select_umz_rank ON select_umz_count.",umz_date_91," = select_umz_rank.",umz_date_91,";",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE select_umzfin ADD COLUMN ",umz_date_81," text;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE select_umzfin SET ",umz_date_81," = concat(",umz_date_91,",'_', rank) WHERE count > 1;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE select_umzfin SET ",umz_date_81," = concat(",umz_date_91,") WHERE count = 1;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE lau2_rootfinal AS SELECT lau2_env_root.*, select_umzfin.pop_tot_81, select_umzfin.",umz_date_81,"  FROM select_umzfin  INNER JOIN lau2_env_root ON select_umzfin.umz_contig = lau2_env_root.umz_contig;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("alter table lau2_rootfinal drop umz_contig;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
# Crer le nouveau fichier de rfrence
q<-paste("CREATE TABLE LAU2_new_ref_81 AS SELECT (LAU2_new_ref_91.*), lau2_rootfinal.",umz_date_81," FROM LAU2_new_ref_91 LEFT OUTER JOIN lau2_rootfinal ON (LAU2_new_ref_91.",id_lau2," = lau2_rootfinal.",id_lau2,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 14. PostGIS database clean-up
res1<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz')")
dbClearResult(res1)
res2<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz_comp')")
dbClearResult(res2)
res3<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_env_root')")
dbClearResult(res3)
res4<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_geom_date')")
dbClearResult(res4)
res6<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_rootfinal')")
dbClearResult(res6)
res7<-dbSendQuery(con,"SELECT DropGeometryTable('poly_env')")
dbClearResult(res7)
res8<-dbSendQuery(con,"SELECT DropGeometryTable('poly_env_id')")
dbClearResult(res8)
res9<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz')")
dbClearResult(res9)
res10<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz_rank')")
dbClearResult(res10)
res11<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz_count')")
dbClearResult(res11)
res12<-dbSendQuery(con,"SELECT DropGeometryTable('select_umzfin')")
dbClearResult(res12)
res13<-dbSendQuery(con,"SELECT DropGeometryTable('simplerings')")
dbClearResult(res13)
res14<-dbSendQuery(con,"SELECT DropGeometryTable('simplelines')")
dbClearResult(res14)
res15<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz_pt')")
dbClearResult(res15)
res16<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_new_ref_91')")
dbClearResult(res16)


################################ 1971 ###################################

# 10. Slection LAU2 pour t-1 et cration des enveloppes + limination des trous
q<-paste("create table ",lau2_date," as (select * from LAU2_new_ref_81 WHERE ",select_lau2_71," >= ",seuilselect," OR ",select_lau2_61," >= ",seuilselect,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz as (select ",umz_date_81,", ST_Union(geom) as geom from ",lau2_date," GROUP BY
         ",umz_date_81,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index env_umz_geom_gist on env_umz using gist(geom);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz_comp as (select ",umz_date_81,", st_exteriorRing((st_dump(geom)).geom) as g from env_umz);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index env_umz_comp_g_gist on env_umz_comp using gist(g);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 11. Reconstruire les enveloppes umz t-1 en polygones
q<-paste("create table simplerings as (select st_linemerge(st_union(g)) as g from env_umz_comp);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table simplelines as (select (st_dump(g)).geom as g from simplerings);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table poly_env as (select (st_dump (st_polygonize(distinct g))).geom as g from simplelines);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index poly_env_g_gist on poly_env using gist(g);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz_pt as (select ",umz_date_81,", st_pointOnSurface((st_dump(geom)).geom) as geom from env_umz);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 12. Rcuprer les IDs des enveloppes et identifier les UMZ t-1 contigues
# Ajout de l'id
q<- paste("alter table poly_env add column gid serial primary key;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
# Recuperation des id par jointure spatiale
q<-paste("create table poly_env_id as (select ",umz_date_81,", g from env_umz_pt d, poly_env s where st_contains(s.g, d.geom));",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE poly_env_id ADD COLUMN gid_a serial primary key;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE poly_env_id ADD COLUMN umz_contig text;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE poly_env_id SET umz_contig = concat(",umz_date_81,",'_', gid_a);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 13. METHODE ROOT - Slection des LAU2 qui composent des UMZ t-1 de 10 000 habitants et plus
q<- paste("CREATE TABLE lau2_env_root AS SELECT DISTINCT ON (LAU2_new_ref_81.",id_lau2,") LAU2_new_ref_81.*, poly_env_id.umz_contig from LAU2_new_ref_81, poly_env_id WHERE poly_env_id.g && LAU2_new_ref_81.geom AND ST_Contains(poly_env_id.g, ST_PointOnSurface(LAU2_new_ref_81.geom));",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz AS SELECT umz_contig, SUM(",pop_lau2_71,") AS pop_tot_71, SUM(",pop_lau2_61,") AS pop_tot_61, MIN(",umz_date_81,") AS ",umz_date_81," FROM lau2_env_root GROUP BY umz_contig ORDER BY MIN(",umz_date_81,") ASC, pop_tot_71 DESC;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("DELETE FROM select_umz WHERE pop_tot_71<10000 AND pop_tot_61<10000;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz_rank AS SELECT *, rank() OVER (PARTITION BY ",umz_date_81," ORDER BY pop_tot_71 DESC) FROM select_umz;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz_count AS SELECT ",umz_date_81,", COUNT(",umz_date_81,") FROM select_umz GROUP BY ",umz_date_81,";",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umzfin AS SELECT select_umz_rank.*, select_umz_count.count  FROM select_umz_count  INNER JOIN select_umz_rank ON select_umz_count.",umz_date_81," = select_umz_rank.",umz_date_81,";",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE select_umzfin ADD COLUMN ",umz_date_71," text;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE select_umzfin SET ",umz_date_71," = concat(",umz_date_81,",'_', rank) WHERE count > 1;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE select_umzfin SET ",umz_date_71," = concat(",umz_date_81,") WHERE count = 1;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE lau2_rootfinal AS SELECT lau2_env_root.*, select_umzfin.pop_tot_71, select_umzfin.",umz_date_71,"  FROM select_umzfin  INNER JOIN lau2_env_root ON select_umzfin.umz_contig = lau2_env_root.umz_contig;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("alter table lau2_rootfinal drop umz_contig;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
# Crer le nouveau fichier de rfrence
q<-paste("CREATE TABLE LAU2_new_ref_71 AS SELECT (LAU2_new_ref_81.*), lau2_rootfinal.",umz_date_71," FROM LAU2_new_ref_81 LEFT OUTER JOIN lau2_rootfinal ON (LAU2_new_ref_81.",id_lau2," = lau2_rootfinal.",id_lau2,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 14. PostGIS database clean-up
res1<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz')")
dbClearResult(res1)
res2<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz_comp')")
dbClearResult(res2)
res3<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_env_root')")
dbClearResult(res3)
res4<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_geom_date')")
dbClearResult(res4)
res6<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_rootfinal')")
dbClearResult(res6)
res7<-dbSendQuery(con,"SELECT DropGeometryTable('poly_env')")
dbClearResult(res7)
res8<-dbSendQuery(con,"SELECT DropGeometryTable('poly_env_id')")
dbClearResult(res8)
res9<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz')")
dbClearResult(res9)
res10<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz_rank')")
dbClearResult(res10)
res11<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz_count')")
dbClearResult(res11)
res12<-dbSendQuery(con,"SELECT DropGeometryTable('select_umzfin')")
dbClearResult(res12)
res13<-dbSendQuery(con,"SELECT DropGeometryTable('simplerings')")
dbClearResult(res13)
res14<-dbSendQuery(con,"SELECT DropGeometryTable('simplelines')")
dbClearResult(res14)
res15<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz_pt')")
dbClearResult(res15)
res14<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_new_ref_81')")
dbClearResult(res14)


################################ 1961 ###################################

# 10. Selection of the LAU2 for t-1, perimeters creation and "holes"removal
q<-paste("create table ",lau2_date," as (select * from LAU2_new_ref_71 WHERE ",select_lau2_61," >= ",seuilselect,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz as (select ",umz_date_71,", ST_Union(geom) as geom from ",lau2_date," GROUP BY
         ",umz_date_71,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index env_umz_geom_gist on env_umz using gist(geom);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz_comp as (select ",umz_date_71,", st_exteriorRing((st_dump(geom)).geom) as g from env_umz);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index env_umz_comp_g_gist on env_umz_comp using gist(g);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 11. Transforming umz t-1 to polygons
q<-paste("create table simplerings as (select st_linemerge(st_union(g)) as g from env_umz_comp);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table simplelines as (select (st_dump(g)).geom as g from simplerings);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table poly_env as (select (st_dump (st_polygonize(distinct g))).geom as g from simplelines);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create index poly_env_g_gist on poly_env using gist(g);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<-paste("create table env_umz_pt as (select ",umz_date_71,", st_pointOnSurface((st_dump(geom)).geom) as geom from env_umz);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 12. Retrieving perimeters IDs and identifying contiguous UMZ t-1 
# Adding ID
q<- paste("alter table poly_env add column gid serial primary key;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
# ID retrieving through spatial joint
q<-paste("create table poly_env_id as (select ",umz_date_71,", g from env_umz_pt d, poly_env s where st_contains(s.g, d.geom));",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE poly_env_id ADD COLUMN gid_a serial primary key;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE poly_env_id ADD COLUMN umz_contig text;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE poly_env_id SET umz_contig = concat(",umz_date_71,",'_', gid_a);",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 13. ROOT METHOD - Selection of the LAU2 taking part of UMZ t-1 over 10 000 inh.
q<- paste("CREATE TABLE lau2_env_root AS SELECT DISTINCT ON (LAU2_new_ref_71.",id_lau2,") LAU2_new_ref_71.*, poly_env_id.umz_contig from LAU2_new_ref_71, poly_env_id WHERE poly_env_id.g && LAU2_new_ref_71.geom AND ST_Contains(poly_env_id.g, ST_PointOnSurface(LAU2_new_ref_71.geom));",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz AS SELECT umz_contig, SUM(",pop_lau2_61,") AS pop_tot_61, MIN(",umz_date_71,") AS ",umz_date_71," FROM lau2_env_root GROUP BY umz_contig ORDER BY MIN(",umz_date_71,") ASC, pop_tot_61 DESC;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("DELETE FROM select_umz WHERE pop_tot_61<10000;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz_rank AS SELECT *, rank() OVER (PARTITION BY ",umz_date_71," ORDER BY pop_tot_61 DESC) FROM select_umz;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umz_count AS SELECT ",umz_date_71,", COUNT(",umz_date_71,") FROM select_umz GROUP BY ",umz_date_71,";",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE select_umzfin AS SELECT select_umz_rank.*, select_umz_count.count  FROM select_umz_count  INNER JOIN select_umz_rank ON select_umz_count.",umz_date_71," = select_umz_rank.",umz_date_71,";",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("ALTER TABLE select_umzfin ADD COLUMN ",umz_date_61," text;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE select_umzfin SET ",umz_date_61," = concat(",umz_date_71,",'_', rank) WHERE count > 1;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("UPDATE select_umzfin SET ",umz_date_61," = concat(",umz_date_71,") WHERE count = 1;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("CREATE TABLE lau2_rootfinal AS SELECT lau2_env_root.*, select_umzfin.pop_tot_61, select_umzfin.",umz_date_61,"  FROM select_umzfin  INNER JOIN lau2_env_root ON select_umzfin.umz_contig = lau2_env_root.umz_contig;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
q<- paste("alter table lau2_rootfinal drop umz_contig;",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)
# Creation of the new reference file
q<-paste("CREATE TABLE LAU2_new_ref_61 AS SELECT (LAU2_new_ref_71.*), lau2_rootfinal.",umz_date_61," FROM LAU2_new_ref_71 LEFT OUTER JOIN lau2_rootfinal ON (LAU2_new_ref_71.",id_lau2," = lau2_rootfinal.",id_lau2,");",sep="")
res<-dbSendQuery(con,q)
dbClearResult(res)

# 14. PostGIS database clean-up
res1<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz')")
dbClearResult(res1)
res2<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz_comp')")
dbClearResult(res2)
res3<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_env_root')")
dbClearResult(res3)
res4<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_geom_date')")
dbClearResult(res4)
res6<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_rootfinal')")
dbClearResult(res6)
res7<-dbSendQuery(con,"SELECT DropGeometryTable('poly_env')")
dbClearResult(res7)
res8<-dbSendQuery(con,"SELECT DropGeometryTable('poly_env_id')")
dbClearResult(res8)
res9<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz')")
dbClearResult(res9)
res10<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz_rank')")
dbClearResult(res10)
res11<-dbSendQuery(con,"SELECT DropGeometryTable('select_umz_count')")
dbClearResult(res11)
res12<-dbSendQuery(con,"SELECT DropGeometryTable('select_umzfin')")
dbClearResult(res12)
res13<-dbSendQuery(con,"SELECT DropGeometryTable('simplerings')")
dbClearResult(res13)
res14<-dbSendQuery(con,"SELECT DropGeometryTable('simplelines')")
dbClearResult(res14)
res15<-dbSendQuery(con,"SELECT DropGeometryTable('env_umz_pt')")
dbClearResult(res15)
res16<-dbSendQuery(con,"SELECT DropGeometryTable('lau2_new_ref_71')")
dbClearResult(res16)


# 10. Closing the connexion to the database
dbDisconnect(con)